@echo off
REM ---------------------------------------------------------------------------
REM
REM  Copyright (C) Intel Corporation, 2003 - 2006.
REM
REM  File:      trusted_rootCA_gen.bat
REM
REM  Contents:  batch file which creates a demo root CA certificate. 
REM
REM ----------------------------------------------------------------------------

REM ######################################################################
REM ###                                                                ###
REM ### This batch may be called by the Configuration Server program   ###
REM ### in order to generate a demo root CA certificate                ###
REM ### Normally, you won't need this batch, since you should be using ###
REM ### Your corporate CA.                                             ###
REM ### you may customize this script and modify the defaults          ###
REM ### at your own risk.                                              ###
REM ###                                                                ###
REM ######################################################################

setlocal

set PATH= %PATH%;../openssl
echo %PATH%
set TOP=.\trusted_rootCA
set SSLEAY_CONFIG=-config ./trusted_rootCA.cfg
set KEY=.\trusted_key.pem
set CERT=.\trusted_cert.pem
set DAYS=-days 365

rmdir /q /s %TOP%

mkdir %TOP%
mkdir %TOP%\certs 
mkdir %TOP%\crl 
mkdir %TOP%\newcerts
mkdir %TOP%\private
echo 01 > %TOP%\serial
copy nul %TOP%\index.txt


openssl req %SSLEAY_CONFIG% -new -x509 -keyout %TOP%\private\%KEY% -out %TOP%\%CERT% %DAYS%

copy /y %TOP%\%CERT% %TOP%\trusted_cert.cer

endlocal
IF NOT %CALLER_WAITS_ON_EXIT%=="" EXIT




